<?php

/* -----------------------------------------------------------------
 * 	$Id: smatch.php 717 2013-11-05 15:38:31Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	(c) 2013     Gambio GmbH - www.gambio.de
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

class Smatch {

    var $v_export_type;
    var $v_module_name;
    var $v_module_homepage;
    var $v_module_format;
    var $v_module_export_filename;
    var $v_filename;
    var $v_keyname;
    var $v_linkname;
    var $v_delimiter;
    var $v_enclosure;
    var $v_field_filename;
    var $v_field_customers_groups;
    var $v_field_currency;
    var $v_field_shipping_costs;
    var $v_field_shipping_costs_free;
    var $v_field_attributes;
    var $v_field_campaign;
    var $v_field_export;

    function Smatch() {
        $this->formSettings();
    }

    function formSettings() {
        $this->v_export_type = 'comparison';
        $this->v_module_name = 'Smatch.com';
        $this->v_module_homepage = 'www.smatch.com';
        $this->v_module_format = 'csv';
        $this->v_module_export_filename = 'smatch.csv';
        $this->v_filename = 'smatch.php';
        $this->v_keyname = 'SMATCH';
        $this->v_linkname = 'smatch';
        $this->v_delimiter = ';';
        $this->v_enclosure = '"';
        $this->v_field_filename = true;
        $this->v_field_customers_groups = true;
        $this->v_field_currency = true;
        $this->v_field_shipping_costs = true;
        $this->v_field_shipping_costs_free = true;
        $this->v_field_attributes = true;
        $this->v_field_campaign = true;
        $this->v_field_export = true;
    }

    function formAddOn() {
        
    }

    function formatResults($p_products_array) {
        $p_products_array['retail_price'] = number_format((double) $p_products_array['retail_price'], 2, ',', '');
        $p_products_array['products_price'] = number_format((double) $p_products_array['products_price'], 2, ',', '');
        $p_products_array['products_shipping_costs'] = number_format((double) $p_products_array['products_shipping_costs'], 2, ',', '');
        $p_products_array['products_description'] = no_html($p_products_array['products_description']);
        return($p_products_array);
    }

    function exportScheme() {
        $t_csv_fields_array = array();
        $t_csv_fields_array['products_id'] = 'ART_NUMBER';
        $t_csv_fields_array['products_name'] = 'ART_NAME';
        $t_csv_fields_array['products_link'] = 'DEEP_LINK';
        $t_csv_fields_array['products_description'] = 'LONG_DESCRIPTION';
        $t_csv_fields_array['products_image_1'] = 'IMAGE_URL';
        $t_csv_fields_array['products_categories'] = 'CATEGORY';
        $t_csv_fields_array['products_price'] = 'PRICE';
        $t_csv_fields_array['products_ean'] = 'EAN';
        $t_csv_fields_array['products_shippingtime'] = 'DELIVERY_TIME';
        $t_csv_fields_array['products_shipping_costs'] = 'DELIVERY_COSTS';
        $t_csv_fields_array['retail_price'] = 'OLD_PRICE';
        $t_csv_fields_array['products_meta_keywords'] = 'KEYWORDS';
        $t_csv_fields_array['products_stock'] = 'AVAILABLE_PRODUCTS';
        $t_csv_fields_array['manufacturers_name'] = 'BRAND';
        return($t_csv_fields_array);
    }

}

?>